package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.EventType;
import gov.va.vinci.dart.db.EventTypeDAO;

public class EventTypeDAOMock implements EventTypeDAO {
	private static final HashMap<Integer,EventType> IDHash = new HashMap<Integer,EventType>();
	private static final HashMap<String,EventType> NameHash = new HashMap<String,EventType>();
	
	private static boolean initialized = false;

	
	@Override
	public EventType findById(int eventTypeId) throws ObjectNotFoundException {
		initializeEventTypeHash();

		EventType result = IDHash.get(eventTypeId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}

	@Override
	public EventType findByName(String name) throws ObjectNotFoundException {
		initializeEventTypeHash();

		EventType result = NameHash.get(name);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}

	@Override
	public List<EventType> listAll() {
		List<EventType> result = new ArrayList<EventType>();
		
		initializeEventTypeHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	private void initializeEventTypeHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;

		EventType et = new EventType(1);
		et.setName("Initiated");
		et.setDescription("Initiate Data Access Request");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(2);
		et.setName("Submitted");
		et.setDescription("Submitted Data Access Request Packet to NDS");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(3);
		et.setName("Request Amendment Created");
		et.setDescription("Creating Amendment");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(4);
		et.setName("Request Submitted with Changes");
		et.setDescription("Request Submitted with Changes");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(5);
		et.setName("Closed");
		et.setDescription("Data Access Request Closed");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(6);
		et.setName("Review Approval");
		et.setDescription("Review Approval");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(7);
		et.setName("Review Denied");
		et.setDescription("Review Denied");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(8);
		et.setName("Change Requested");
		et.setDescription("Change Requested");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(9);
		et.setName("Request Sent for Review");
		et.setDescription("Request Sent for Review");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(10);
		et.setName("Request Approval");
		et.setDescription("Request Approval");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
		
		et = new EventType(11);
		et.setName("Request Completed");
		et.setDescription("Request Completed");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);

		et = new EventType(12);
		et.setName("Workflow Closed");
		et.setDescription("Workflow Closed");
		IDHash.put(et.getId(), et);
		NameHash.put(et.getName(), et);
	}
}
